/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

class FlowPanel
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int axis;
    private GridBagLayout gb = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private LinkedList springs = new LinkedList();

    public FlowPanel(int axis) {
        this.setLayout(this.gb);
        this.axis = axis;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.springs != null) {
            Iterator it = this.springs.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setBackground(bg);
            }
        }
    }

    public void setLetterBox(int strut) {
        if (this.axis == 0) {
            this.setBorder(BorderFactory.createEmptyBorder(strut, 0, strut, 0));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, strut, 0, strut));
        }
    }

    public void setAnchor(int anchor) {
        this.gbc.anchor = anchor;
    }

    public void setFill(int fill) {
        this.gbc.fill = fill;
    }

    public void add(JComponent comp, double weight) {
        if (this.axis == 0) {
            this.gbc.weightx = weight;
        } else {
            this.gbc.weighty = weight;
        }
        this.gb.setConstraints(comp, this.gbc);
        super.add(comp);
        this.advance();
    }

    public void add(JComponent comp) {
        this.add(comp, 0.0);
    }

    public void addSpring(int strut, double weight) {
        JPanel spring = new JPanel();
        Dimension dims = this.axis == 0 ? new Dimension(strut, 1) : new Dimension(1, strut);
        spring.setMinimumSize(dims);
        spring.setPreferredSize(dims);
        spring.setBackground(this.getBackground());
        this.springs.add(spring);
        this.add(spring, weight);
    }

    private void advance() {
        if (this.axis == 0) {
            ++this.gbc.gridx;
        } else {
            ++this.gbc.gridy;
        }
    }
}

