/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Tty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class IOArea
extends JPanel
implements Tty.Display {
    protected static final int NUM_ROWS = 6;
    protected static final int NUM_COLS = 15;
    private JTextArea area = new JTextArea(6, 15);
    private JScrollPane scroll;
    private boolean caret_enabled = false;

    public IOArea() {
        super(new BorderLayout());
        this.area.setFont(new Font("Monospaced", 0, 12));
        this.area.setEditable(false);
        this.scroll = new JScrollPane(this.area, 22, 31);
        this.scroll.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.scroll, "Center");
        this.area.addFocusListener(new MyFocusListener());
        this.area.getCaret().addChangeListener(new MyFocusListener());
    }

    public void setCaretEnabled(boolean value) {
        this.caret_enabled = value;
        this.area.getCaret().setVisible(value && this.area.hasFocus());
    }

    public void clear() {
        Document doc = this.area.getDocument();
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.area.setCaretPosition(0);
    }

    public void addChar(char c) {
        Document doc = this.area.getDocument();
        try {
            if (c == '\b') {
                if (doc.getLength() > 1) {
                    doc.remove(doc.getLength() - 1, 1);
                }
            } else {
                doc.insertString(doc.getLength(), "" + c, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.area.setCaretPosition(doc.getLength());
    }

    public void addString(String s) {
        Document doc = this.area.getDocument();
        try {
            doc.insertString(doc.getLength(), s, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.area.setCaretPosition(doc.getLength());
    }

    public void scrollToBottom() {
        JScrollBar bar = this.scroll.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
    }

    public int getMark() {
        return this.area.getDocument().getLength();
    }

    public void removeFromMark(int index) {
        try {
            Document doc = this.area.getDocument();
            doc.remove(index, doc.getLength() - index);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void addKeyListener(KeyListener listener) {
        this.area.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.area.removeKeyListener(listener);
    }

    public void grabFocus() {
        this.area.grabFocus();
    }

    public void setFontSize(float size) {
        this.area.setFont(this.area.getFont().deriveFont(size));
    }

    private class MyFocusListener
    implements ChangeListener,
    FocusListener {
        MyFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            IOArea.this.area.getCaret().setVisible(IOArea.this.caret_enabled);
        }

        public void focusLost(FocusEvent e) {
            IOArea.this.area.getCaret().setVisible(false);
        }

        public void stateChanged(ChangeEvent e) {
            Document doc = IOArea.this.area.getDocument();
            if (IOArea.this.area.getCaretPosition() != doc.getLength()) {
                IOArea.this.area.setCaretPosition(doc.getLength());
            }
        }
    }
}

