/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.IOArea;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.hymn.Tty;

class Keyboard
implements Tty.Keyboard {
    private static final int IDLE = 0;
    private static final int WAITING = 1;
    private static final int READY = 2;
    private StringBuffer buf = new StringBuffer();
    private int state = 0;
    private int ready_mark = -1;
    public IOArea display;

    public Keyboard(Tty.Display display) {
        this.display = (IOArea)display;
    }

    public synchronized void clear() {
        this.state = 0;
        this.display.setCaretEnabled(false);
        this.buf = new StringBuffer();
    }

    public synchronized void cancelInput() {
        if (this.state == 1) {
            this.state = 0;
            if (this.ready_mark >= 0) {
                this.display.removeFromMark(this.ready_mark);
                this.buf = new StringBuffer();
                this.ready_mark = -1;
            }
            this.display.setCaretEnabled(false);
        }
    }

    public synchronized void requestInput() {
        if (this.state == 0) {
            this.ready_mark = this.display.getMark();
            this.display.addString("? ");
            this.display.setCaretEnabled(true);
            this.display.grabFocus();
            this.state = 1;
        }
    }

    public synchronized boolean isInputReady() {
        return this.state == 2;
    }

    public synchronized int consumeInput() throws Tty.InputNotReadyException {
        if (this.state != 2) {
            throw new Tty.InputNotReadyException();
        }
        this.display.setCaretEnabled(false);
        this.ready_mark = -1;
        this.state = 0;
        try {
            int ret = Integer.parseInt(this.buf.toString(), 10);
            this.buf = new StringBuffer();
            return ret;
        }
        catch (NumberFormatException e) {
            this.buf = new StringBuffer();
            this.addStringToDisplay(Strings.get("badInputError"));
            return 0;
        }
    }

    public synchronized void keyTyped(char c) {
        if (this.state != 1) {
            return;
        }
        if (Character.isDigit(c)) {
            this.buf.append(c);
            this.display.addChar(c);
        } else if (c == '-') {
            if (this.buf.length() == 0) {
                this.buf.append(c);
                this.display.addChar(c);
            }
        } else if (c == '\n') {
            if (this.buf.length() > 0 && !this.buf.toString().equals("-")) {
                this.state = 2;
                this.display.addChar(c);
            }
        } else if (c == '\b' && this.buf.length() > 0) {
            this.buf.deleteCharAt(this.buf.length() - 1);
            this.display.addChar(c);
        }
        this.display.scrollToBottom();
    }

    private void addStringToDisplay(String what) {
        int i = 0;
        while (i < what.length()) {
            this.display.addChar(what.charAt(i));
            ++i;
        }
    }
}

