/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class MachineFile {
    MachineFile() {
    }

    public static void save(File dest, Cpu cpu) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(dest));
        int i = 0;
        while (i < 32) {
            int val = cpu.getMem(i).getValue() & 0xFF;
            writer.println(Integer.toHexString(val));
            ++i;
        }
        writer.close();
    }

    public static void load(File src, Cpu cpu) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(src));
        int addr = 0;
        int[] vals = new int[32];
        int line_num = 0;
        while (true) {
            ++line_num;
            String line = reader.readLine();
            if (line == null) break;
            if ((line = line.trim()).equals("")) continue;
            try {
                int val;
                vals[addr] = val = Integer.parseInt(line, 16);
                ++addr;
            }
            catch (NumberFormatException e) {
                throw new IOException(String.valueOf(Strings.get("line")) + " " + line_num + ": " + Strings.get("badDataError"));
            }
        }
        reader.close();
        EventLog.Cause cause = new EventLog.Cause();
        addr = 0;
        while (addr < 32) {
            cpu.getMem(addr).setValue(vals[addr], cause);
            ++addr;
        }
        cpu.resetRegisters();
    }
}

