/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.EventLog;
import java.util.Iterator;
import java.util.LinkedList;

class Register {
    private int bits;
    private int shift_dist;
    private int value;
    private EventLog log;
    private LinkedList listeners = new LinkedList();

    public Register(int bits, EventLog log) {
        this.bits = bits;
        this.log = log;
        this.shift_dist = 32 - bits;
        this.value = 0;
    }

    public int getBitCount() {
        return this.bits;
    }

    public int getBitMask() {
        return (1 << this.bits) - 1;
    }

    public int getValue() {
        return this.value;
    }

    public int getValue(EventLog.Cause cause) {
        this.log.doIt(new GetEvent(cause));
        return this.value;
    }

    public void setValue(int value, EventLog.Cause cause) {
        this.log.doIt(new SetEvent(cause, value << this.shift_dist >> this.shift_dist));
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireValueChanged(Event e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).valueChanged(e);
        }
    }

    public static class Event {
        public final Register source;
        public final int value;

        public Event(Register source) {
            this(source, source.getValue());
        }

        public Event(Register source, int value) {
            this.source = source;
            this.value = value;
        }
    }

    public static interface Listener {
        public void valueChanged(Event var1);
    }

    public abstract class AccessEvent
    extends EventLog.Event {
        AccessEvent(EventLog.Cause cause) {
            super(cause);
        }

        public Register getRegister() {
            return Register.this;
        }
    }

    private class GetEvent
    extends AccessEvent {
        GetEvent(EventLog.Cause cause) {
            super(cause);
        }

        public void doIt() {
        }

        public void undoIt() {
        }
    }

    private class SetEvent
    extends AccessEvent {
        private final int old_value;
        private final int new_value;

        SetEvent(EventLog.Cause cause, int new_value) {
            super(cause);
            this.old_value = Register.this.value;
            this.new_value = new_value;
        }

        public void doIt() {
            Register.this.value = this.new_value;
            Register.this.fireValueChanged(new Event(Register.this));
        }

        public void undoIt() {
            Register.this.value = this.old_value;
            Register.this.fireValueChanged(new Event(Register.this));
        }
    }
}

