/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.FlowPanel;
import edu.csbsju.socs.hymn.Register;
import edu.csbsju.socs.hymn.Strings;
import edu.csbsju.socs.hymn.WordView;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class RegisterPanel
extends FlowPanel
implements Register.Listener {
    private Cpu cpu;
    private JPanel reg_panel;
    private JPanel flags_panel;
    private JLabel pc_label = new JLabel();
    private JLabel ir_label = new JLabel();
    private JLabel ac_label = new JLabel();
    private JLabel zero_label = new JLabel();
    private JLabel pos_label = new JLabel();
    private WordView pc_view;
    private WordView ir_view;
    private WordView ac_view;
    private JTextField zero_flag = new JTextField(4);
    private JTextField pos_flag = new JTextField(4);

    RegisterPanel(Cpu cpu) {
        super(1);
        this.cpu = cpu;
        this.reg_panel = this.createRegisterPanel();
        this.add(this.reg_panel);
        this.addSpring(5, 0.0);
        this.flags_panel = this.createFlagsPanel();
        this.add(this.flags_panel);
    }

    void renewStrings() {
        this.pc_label.setText(Strings.get("pcLabel"));
        this.ir_label.setText(Strings.get("irLabel"));
        this.ac_label.setText(Strings.get("acLabel"));
        this.zero_label.setText(Strings.get("zeroLabel"));
        this.pos_label.setText(Strings.get("posLabel"));
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.reg_panel != null) {
            this.reg_panel.setBackground(bg);
        }
        if (this.flags_panel != null) {
            this.flags_panel.setBackground(bg);
        }
        if (this.pc_view != null) {
            this.pc_view.setBackground(bg);
        }
        if (this.ir_view != null) {
            this.ir_view.setBackground(bg);
        }
        if (this.ac_view != null) {
            this.ac_view.setBackground(bg);
        }
    }

    private JPanel createRegisterPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.ac_view = new WordView(this.cpu.getAC());
        this.pc_view = new WordView(this.cpu.getPC());
        this.ir_view = new WordView(this.cpu.getIR());
        this.ac_view.setType(1);
        this.pc_view.setType(0);
        this.ir_view.setType(2);
        this.ac_view.setLabel(this.ac_label);
        this.pc_view.setLabel(this.pc_label);
        this.ir_view.setLabel(this.ir_label);
        this.zero_flag.setEditable(false);
        this.pos_flag.setEditable(false);
        GridBagConstraints GBC = new GridBagConstraints();
        GBC.anchor = 13;
        GBC.gridx = 0;
        GBC.gridy = 0;
        ret.add((Component)this.pc_label, GBC);
        GBC.gridx = 0;
        GBC.gridy = 1;
        ret.add((Component)this.ir_label, GBC);
        GBC.gridx = 0;
        GBC.gridy = 2;
        ret.add((Component)this.ac_label, GBC);
        GBC.anchor = 13;
        GBC.gridx = 1;
        GBC.gridy = 0;
        ret.add((Component)this.pc_view, GBC);
        GBC.gridx = 1;
        GBC.gridy = 1;
        ret.add((Component)this.ir_view, GBC);
        GBC.gridx = 1;
        GBC.gridy = 2;
        ret.add((Component)this.ac_view, GBC);
        return ret;
    }

    private JPanel createFlagsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints GBC = new GridBagConstraints();
        GBC.anchor = 13;
        GBC.gridx = 0;
        GBC.gridy = 3;
        ret.add((Component)this.zero_label, GBC);
        GBC.gridx = 0;
        GBC.gridy = 4;
        ret.add((Component)this.pos_label, GBC);
        GBC.anchor = 17;
        GBC.gridx = 1;
        GBC.gridy = 3;
        ret.add((Component)this.zero_flag, GBC);
        GBC.gridx = 1;
        GBC.gridy = 4;
        ret.add((Component)this.pos_flag, GBC);
        this.cpu.getAC().addListener(this);
        this.valueChanged(new Register.Event(this.cpu.getAC()));
        return ret;
    }

    public void valueChanged(Register.Event event) {
        if (event.source == this.cpu.getAC()) {
            this.zero_flag.setText("" + (event.value == 0));
            this.pos_flag.setText("" + (event.value > 0));
        }
    }

    public void setFontSize(float size) {
        this.pc_label.setFont(this.pc_label.getFont().deriveFont(size));
        this.ir_label.setFont(this.ir_label.getFont().deriveFont(size));
        this.ac_label.setFont(this.ac_label.getFont().deriveFont(size));
        this.zero_label.setFont(this.zero_label.getFont().deriveFont(size));
        this.pos_label.setFont(this.pos_label.getFont().deriveFont(size));
        this.zero_flag.setFont(this.zero_flag.getFont().deriveFont(size));
        this.pos_flag.setFont(this.pos_flag.getFont().deriveFont(size));
        this.pc_view.setFontSize(size);
        this.ir_view.setFontSize(size);
        this.ac_view.setFontSize(size);
    }

    public void mapViews(HashMap map) {
        map.put(this.ac_view.getSource(), this.ac_view);
        map.put(this.pc_view.getSource(), this.pc_view);
        map.put(this.ir_view.getSource(), this.ir_view);
    }
}

