/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Cpu;
import edu.csbsju.socs.hymn.EventLog;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class Tty {
    private Cpu cpu = null;
    private Display display = null;
    private Keyboard keyboard = null;

    public Tty(Display d, Keyboard k) {
        this.display = d;
        this.keyboard = k;
        if (d != null) {
            d.addKeyListener(new DisplayListener());
        }
    }

    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(Keyboard k) {
        this.keyboard = k;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void cancelInput() {
        if (this.keyboard != null) {
            this.keyboard.cancelInput();
        }
    }

    public void requestInput() {
        if (this.keyboard != null) {
            this.keyboard.requestInput();
        }
    }

    public boolean isInputReady() {
        if (this.keyboard != null) {
            return this.keyboard.isInputReady();
        }
        return true;
    }

    public int consumeInput(EventLog.Cause cause) throws InputNotReadyException {
        if (this.keyboard == null) {
            return 0;
        }
        int mark = this.display.getMark();
        int ret = this.keyboard.consumeInput();
        if (this.cpu != null) {
            this.cpu.getLog().add(new DisplayAddEvent(cause, String.valueOf(ret) + "\n", mark));
        }
        return ret;
    }

    public void reset() {
        if (this.display != null) {
            this.display.clear();
        }
        if (this.keyboard != null) {
            this.keyboard.clear();
        }
    }

    public void setValue(int value, EventLog.Cause cause) {
        if (this.display != null) {
            int mark = this.display.getMark();
            this.display.addString(String.valueOf(value) + "\n");
            if (this.cpu != null) {
                this.cpu.getLog().add(new DisplayAddEvent(cause, String.valueOf(value) + "\n", mark));
            }
        }
    }

    public static class InputNotReadyException
    extends Exception {
        public InputNotReadyException() {
        }

        public InputNotReadyException(String msg) {
            super(msg);
        }
    }

    public static interface Display {
        public void grabFocus();

        public void addKeyListener(KeyListener var1);

        public void removeKeyListener(KeyListener var1);

        public void addChar(char var1);

        public void addString(String var1);

        public void clear();

        public int getMark();

        public void removeFromMark(int var1);
    }

    public static interface Keyboard {
        public void clear();

        public void cancelInput();

        public void requestInput();

        public boolean isInputReady();

        public int consumeInput() throws InputNotReadyException;

        public void keyTyped(char var1);
    }

    private class DisplayListener
    implements KeyListener {
        DisplayListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public synchronized void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (c == '\b' || c == '\u007f' || e.paramString().indexOf("Backspace") >= 0) {
                c = '\b';
            }
            if (Tty.this.keyboard != null) {
                Tty.this.keyboard.keyTyped(c);
            }
        }
    }

    private class DisplayAddEvent
    extends EventLog.Event {
        private String data;
        private int pos;

        DisplayAddEvent(EventLog.Cause cause, String data, int pos) {
            super(cause);
            this.data = data;
            this.pos = pos;
        }

        public void doIt() {
            Tty.this.display.addString(this.data);
        }

        public void undoIt() {
            Tty.this.display.removeFromMark(this.pos);
        }
    }
}

