/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;

class TypeSelector
extends JButton {
    public static final int HEX_TYPE = 0;
    public static final int DEC_TYPE = 1;
    public static final int ASSEM_TYPE = 2;
    private static final String[] type_name = new String[]{"hexType", "decType", "instrType"};
    private int type = 0;
    private LinkedList listeners = new LinkedList();
    private boolean in_setValue = false;

    TypeSelector() {
        this.setForeground(Color.black);
        this.computeSize();
        MyListener listener = new MyListener();
        this.addActionListener(listener);
        this.setValue(1);
    }

    void renewStrings() {
        this.setText(Strings.get(type_name[this.type]));
        this.computeSize();
    }

    private void computeSize() {
        Font f = this.getFont();
        FontRenderContext frc = new FontRenderContext(null, false, false);
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < 3) {
            Rectangle2D rect = f.getStringBounds(Strings.get(type_name[i]), frc);
            width = Math.max(width, (int)Math.ceil(rect.getWidth()));
            height = Math.max(height, (int)Math.ceil(rect.getHeight()));
            ++i;
        }
        Insets insets = this.getInsets();
        Dimension dims = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        this.setPreferredSize(dims);
        this.setMinimumSize(dims);
    }

    public int getValue() {
        return this.type;
    }

    public void setValue(int type) {
        this.type = type;
        this.setText(Strings.get(type_name[type]));
        if (!this.in_setValue) {
            this.in_setValue = true;
            this.fireTypeChanged(new Event(this, type));
            this.in_setValue = false;
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireTypeChanged(Event e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).typeChanged(e);
        }
    }

    public void setFontSize(float size) {
        this.setFont(this.getFont().deriveFont(size));
        this.computeSize();
    }

    public static class Event {
        public final TypeSelector source;
        public final int type;

        public Event(TypeSelector source) {
            this(source, source.getValue());
        }

        public Event(TypeSelector source, int type) {
            this.source = source;
            this.type = type;
        }
    }

    public static interface Listener {
        public void typeChanged(Event var1);
    }

    private class MyListener
    implements ActionListener {
        MyListener() {
        }

        public void actionPerformed(ActionEvent event) {
            TypeSelector.this.setValue((TypeSelector.this.type + 1) % 3);
        }
    }
}

