/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.hymn;

import edu.csbsju.socs.hymn.Assembler;
import edu.csbsju.socs.hymn.EventLog;
import edu.csbsju.socs.hymn.Register;
import edu.csbsju.socs.hymn.TypeSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class WordView
extends JPanel {
    private EventLog.Cause cause = new EventLog.Cause();
    private Register source;
    private JLabel label;
    private JPanel bit_panel;
    private BitButton[] bits;
    private ValueField value_field;

    public WordView(Register source) {
        this.source = source;
        this.label = new JLabel(" ");
        this.label.setHorizontalAlignment(2);
        int num_bits = source.getBitCount();
        this.bit_panel = new JPanel(new GridLayout(1, num_bits, 0, 0));
        this.bit_panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.black)));
        this.bits = new BitButton[num_bits];
        int i = this.bits.length - 1;
        while (i >= 0) {
            this.bits[i] = new BitButton(1 << i);
            this.bit_panel.add(this.bits[i]);
            --i;
        }
        this.value_field = new ValueField();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add(this.label);
        this.add(this.bit_panel);
        this.add(this.value_field);
        this.setHighlighted(false);
    }

    public Register getSource() {
        return this.source;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.label != null) {
            this.label.setBackground(bg);
        }
        if (this.value_field != null) {
            this.value_field.setBackground(bg);
        }
        if (this.bit_panel != null) {
            this.bit_panel.setBackground(bg);
        }
    }

    public void setFontSize(float size) {
        this.label.setFont(this.label.getFont().deriveFont(size));
        this.value_field.setFont(this.value_field.getFont().deriveFont(size));
        Font f = this.bits[0].getFont().deriveFont(size);
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].setFont(f);
            ++i;
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JTextField getField() {
        return this.value_field;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public void setLabel(String value) {
        this.label.setText(value);
    }

    public void setHighlighted(boolean value) {
        this.label.setForeground(value ? Color.red : Color.black);
    }

    public boolean isHighlighted() {
        return this.label.getForeground() == Color.red;
    }

    public void setType(int type) {
        this.value_field.setType(type);
    }

    public void setTypeSelector(TypeSelector selector) {
        this.value_field.setTypeSelector(selector);
    }

    private class BitButton
    extends JButton
    implements ActionListener,
    Register.Listener {
        private int place_value;

        public BitButton(int place_value) {
            super("0");
            this.place_value = place_value;
            this.setBackground(Color.yellow);
            this.setForeground(Color.blue);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.addActionListener(this);
            WordView.this.source.addListener(this);
            this.valueChanged(new Register.Event(WordView.this.source));
        }

        public void actionPerformed(ActionEvent e) {
            int bit = 1 - Integer.parseInt(this.getText());
            int val = WordView.this.source.getValue();
            val = bit == 0 ? (val &= ~this.place_value) : (val |= this.place_value);
            WordView.this.source.setValue(val, WordView.this.cause);
        }

        public void valueChanged(Register.Event event) {
            int pos = (event.value & this.place_value) != 0 ? 1 : 0;
            this.setText("" + pos);
            this.setForeground(pos == 0 ? Color.blue : Color.yellow);
            this.setBackground(pos == 0 ? Color.yellow : Color.blue);
        }
    }

    private class ValueField
    extends JTextField
    implements Register.Listener,
    TypeSelector.Listener,
    ActionListener,
    FocusListener {
        private TypeSelector selector = null;
        private int type = 0;

        ValueField() {
            super(8);
            this.setHorizontalAlignment(4);
            this.setText("00");
            this.addActionListener(this);
            WordView.this.source.addListener(this);
            this.displayValue(WordView.this.source.getValue());
            this.addFocusListener(this);
        }

        public void setTypeSelector(TypeSelector value) {
            if (this.selector != null) {
                this.selector.removeListener(this);
            }
            this.selector = value;
            this.selector.addListener(this);
            this.typeChanged(new TypeSelector.Event(this.selector));
        }

        public void setType(int type) {
            this.type = type;
            switch (type) {
                case 0: 
                case 1: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    this.setHorizontalAlignment(2);
                }
            }
            this.valueChanged(new Register.Event(WordView.this.source));
        }

        public void actionPerformed(ActionEvent event) {
            if (!this.commitValue()) {
                this.selectAll();
            } else {
                Component next = this.getNextFocusableComponent();
                if (next != null) {
                    next.requestFocus();
                }
            }
        }

        private boolean commitValue() {
            EventLog.Cause cause = new EventLog.Cause();
            String val = this.getText();
            try {
                switch (this.type) {
                    case 0: {
                        WordView.this.source.setValue(Integer.parseInt(val, 16), cause);
                        break;
                    }
                    case 1: {
                        WordView.this.source.setValue(Integer.parseInt(val, 10), cause);
                        break;
                    }
                    case 2: {
                        WordView.this.source.setValue(Assembler.assemble(val, 2), cause);
                    }
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (Assembler.Error e) {
                return false;
            }
        }

        public void valueChanged(Register.Event event) {
            this.displayValue(event.value);
        }

        public void typeChanged(TypeSelector.Event event) {
            this.setType(event.type);
        }

        public void focusGained(FocusEvent e) {
            this.selectAll();
        }

        public void focusLost(FocusEvent e) {
            if (!this.commitValue()) {
                this.displayValue(WordView.this.source.getValue());
            }
        }

        private void displayValue(int value) {
            String new_val = "???";
            switch (this.type) {
                case 0: {
                    new_val = Integer.toHexString(value & WordView.this.source.getBitMask());
                    while (new_val.length() < 2) {
                        new_val = "0" + new_val;
                    }
                    break;
                }
                case 1: {
                    new_val = "" + value;
                    break;
                }
                case 2: {
                    new_val = Assembler.disassemble(value);
                }
            }
            this.setText(new_val);
        }
    }
}

