/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.util;

import edu.csbsju.socs.util.Strings;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GifEncoder {
    private short width_;
    private short height_;
    private int numColors_;
    private byte[] pixels_;
    private byte[] colors_;
    private ScreenDescriptor sd_;
    private ImageDescriptor id_;

    public GifEncoder(Image image) throws AWTException {
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] values = new int[this.width_ * this.height_];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, values, 0, (int)this.width_);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException(String.valueOf(Strings.get("grabberError")) + ": " + grabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[][] r = new byte[this.width_][this.height_];
        byte[][] g = new byte[this.width_][this.height_];
        byte[][] b = new byte[this.width_][this.height_];
        int index = 0;
        int y = 0;
        while (y < this.height_) {
            int x = 0;
            while (x < this.width_) {
                r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                b[x][y] = (byte)(values[index] & 0xFF);
                ++index;
                ++x;
            }
            ++y;
        }
        this.ToIndexedColor(r, g, b);
    }

    public GifEncoder(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.width_ = (short)r.length;
        this.height_ = (short)r[0].length;
        this.ToIndexedColor(r, g, b);
    }

    public void write(OutputStream output) throws IOException {
        BitUtils.WriteString(output, "GIF87a");
        ScreenDescriptor sd = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        sd.Write(output);
        output.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor id = new ImageDescriptor(this.width_, this.height_, ',');
        id.Write(output);
        byte codesize = BitUtils.BitsNeeded(this.numColors_);
        if (codesize == 1) {
            codesize = (byte)(codesize + 1);
        }
        output.write(codesize);
        LZWCompressor.LZWCompress(output, codesize, this.pixels_);
        output.write(0);
        id = new ImageDescriptor(0, 0, ';');
        id.Write(output);
        output.flush();
    }

    void ToIndexedColor(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        int colornum = 0;
        int x = 0;
        while (x < this.width_) {
            int y = 0;
            while (y < this.height_) {
                int search = 0;
                while (search < colornum) {
                    if (this.colors_[search * 3] == r[x][y] && this.colors_[search * 3 + 1] == g[x][y] && this.colors_[search * 3 + 2] == b[x][y]) break;
                    ++search;
                }
                if (search > 255) {
                    throw new AWTException(Strings.get("manyColorError"));
                }
                this.pixels_[y * this.width_ + x] = (byte)search;
                if (search == colornum) {
                    this.colors_[search * 3] = r[x][y];
                    this.colors_[search * 3 + 1] = g[x][y];
                    this.colors_[search * 3 + 2] = b[x][y];
                    ++colornum;
                }
                ++y;
            }
            ++x;
        }
        this.numColors_ = 1 << BitUtils.BitsNeeded(colornum);
        byte[] copy = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.numColors_ * 3);
        this.colors_ = copy;
    }

    public static void toFile(Image img, String filename) {
        try {
            new GifEncoder(img).write(new FileOutputStream(filename));
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Strings.get("generalError")) + ": " + e);
        }
    }

    public static void toFile(Image img, File file) {
        try {
            new GifEncoder(img).write(new FileOutputStream(file));
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Strings.get("generalError")) + ": " + e);
        }
    }

    private static class BitFile {
        OutputStream output_;
        byte[] buffer_;
        int index_;
        int bitsLeft_;

        public BitFile(OutputStream output) {
            this.output_ = output;
            this.buffer_ = new byte[256];
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }

        public void Flush() throws IOException {
            int numBytes = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
            if (numBytes > 0) {
                this.output_.write(numBytes);
                this.output_.write(this.buffer_, 0, numBytes);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
        }

        public void WriteBits(int bits, int numbits) throws IOException {
            int bitsWritten = 0;
            int numBytes = 255;
            do {
                if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                    this.output_.write(numBytes);
                    this.output_.write(this.buffer_, 0, numBytes);
                    this.buffer_[0] = 0;
                    this.index_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (numbits <= this.bitsLeft_) {
                    int n = this.index_;
                    this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << numbits) - 1) << 8 - this.bitsLeft_);
                    bitsWritten += numbits;
                    this.bitsLeft_ -= numbits;
                    numbits = 0;
                    continue;
                }
                int n = this.index_++;
                this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                bitsWritten += this.bitsLeft_;
                bits >>= this.bitsLeft_;
                numbits -= this.bitsLeft_;
                this.buffer_[this.index_] = 0;
                this.bitsLeft_ = 8;
            } while (numbits != 0);
        }
    }

    private static class LZWStringTable {
        private static final int RES_CODES = 2;
        private static final short HASH_FREE = -1;
        private static final short NEXT_FIRST = -1;
        private static final int MAXBITS = 12;
        private static final int MAXSTR = 4096;
        private static final short HASHSIZE = 9973;
        private static final short HASHSTEP = 2039;
        byte[] strChr_ = new byte[4096];
        short[] strNxt_ = new short[4096];
        short[] strHsh_ = new short[9973];
        short numStrings_;

        public int AddCharString(short index, byte b) {
            if (this.numStrings_ >= 4096) {
                return 65535;
            }
            int hshidx = LZWStringTable.Hash((short)index, b);
            while (this.strHsh_[hshidx] != -1) {
                hshidx = (hshidx + 2039) % 9973;
            }
            this.strHsh_[hshidx] = this.numStrings_;
            this.strChr_[this.numStrings_] = b;
            this.strNxt_[this.numStrings_] = index != -1 ? index : -1;
            short s = this.numStrings_;
            this.numStrings_ = (short)(s + 1);
            return s;
        }

        public short FindCharString(short index, byte b) {
            short nxtidx;
            if (index == -1) {
                return b;
            }
            int hshidx = LZWStringTable.Hash(index, b);
            while ((nxtidx = this.strHsh_[hshidx]) != -1) {
                if (this.strNxt_[nxtidx] == index && this.strChr_[nxtidx] == b) {
                    return nxtidx;
                }
                hshidx = (hshidx + 2039) % 9973;
            }
            return -1;
        }

        public void ClearTable(int codesize) {
            this.numStrings_ = 0;
            int q = 0;
            while (q < 9973) {
                this.strHsh_[q] = -1;
                ++q;
            }
            int w = (1 << codesize) + 2;
            int q2 = 0;
            while (q2 < w) {
                this.AddCharString((short)-1, (byte)q2);
                ++q2;
            }
        }

        public static int Hash(short index, byte lastbyte) {
            return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
        }
    }

    private static class LZWCompressor {
        LZWCompressor() {
        }

        public static void LZWCompress(OutputStream output, int codesize, byte[] toCompress) throws IOException {
            short prefix = -1;
            BitFile bitFile = new BitFile(output);
            LZWStringTable strings = new LZWStringTable();
            int clearcode = 1 << codesize;
            int endofinfo = clearcode + 1;
            int numbits = codesize + 1;
            int limit = (1 << numbits) - 1;
            strings.ClearTable(codesize);
            bitFile.WriteBits(clearcode, numbits);
            int loop = 0;
            while (loop < toCompress.length) {
                byte c = toCompress[loop];
                short index = strings.FindCharString(prefix, c);
                if (index != -1) {
                    prefix = index;
                } else {
                    bitFile.WriteBits(prefix, numbits);
                    if (strings.AddCharString(prefix, c) > limit) {
                        if (++numbits > 12) {
                            bitFile.WriteBits(clearcode, numbits - 1);
                            strings.ClearTable(codesize);
                            numbits = codesize + 1;
                        }
                        limit = (1 << numbits) - 1;
                    }
                    prefix = (short)((short)c & 0xFF);
                }
                ++loop;
            }
            if (prefix != -1) {
                bitFile.WriteBits(prefix, numbits);
            }
            bitFile.WriteBits(endofinfo, numbits);
            bitFile.Flush();
        }
    }

    private static class ScreenDescriptor {
        public short localScreenWidth_;
        public short localScreenHeight_;
        private byte byte_;
        public byte backgroundColorIndex_;
        public byte pixelAspectRatio_;

        public ScreenDescriptor(short width, short height, int numColors) {
            this.localScreenWidth_ = width;
            this.localScreenHeight_ = height;
            this.SetGlobalColorTableSize((byte)(BitUtils.BitsNeeded(numColors) - 1));
            this.SetGlobalColorTableFlag((byte)1);
            this.SetSortFlag((byte)0);
            this.SetColorResolution((byte)7);
            this.backgroundColorIndex_ = 0;
            this.pixelAspectRatio_ = 0;
        }

        public void Write(OutputStream output) throws IOException {
            BitUtils.WriteWord(output, this.localScreenWidth_);
            BitUtils.WriteWord(output, this.localScreenHeight_);
            output.write(this.byte_);
            output.write(this.backgroundColorIndex_);
            output.write(this.pixelAspectRatio_);
        }

        public void SetGlobalColorTableSize(byte num) {
            this.byte_ = (byte)(this.byte_ | num & 7);
        }

        public void SetSortFlag(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 1) << 3);
        }

        public void SetColorResolution(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 7) << 4);
        }

        public void SetGlobalColorTableFlag(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 1) << 7);
        }
    }

    private static class ImageDescriptor {
        public byte separator_;
        public short leftPosition_;
        public short topPosition_;
        public short width_;
        public short height_;
        private byte byte_;

        public ImageDescriptor(short width, short height, char separator) {
            this.separator_ = (byte)separator;
            this.leftPosition_ = 0;
            this.topPosition_ = 0;
            this.width_ = width;
            this.height_ = height;
            this.SetLocalColorTableSize((byte)0);
            this.SetReserved((byte)0);
            this.SetSortFlag((byte)0);
            this.SetInterlaceFlag((byte)0);
            this.SetLocalColorTableFlag((byte)0);
        }

        public void Write(OutputStream output) throws IOException {
            output.write(this.separator_);
            BitUtils.WriteWord(output, this.leftPosition_);
            BitUtils.WriteWord(output, this.topPosition_);
            BitUtils.WriteWord(output, this.width_);
            BitUtils.WriteWord(output, this.height_);
            output.write(this.byte_);
        }

        public void SetLocalColorTableSize(byte num) {
            this.byte_ = (byte)(this.byte_ | num & 7);
        }

        public void SetReserved(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 3) << 3);
        }

        public void SetSortFlag(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 1) << 5);
        }

        public void SetInterlaceFlag(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 1) << 6);
        }

        public void SetLocalColorTableFlag(byte num) {
            this.byte_ = (byte)(this.byte_ | (num & 1) << 7);
        }
    }

    private static class BitUtils {
        BitUtils() {
        }

        /*
         * Unable to fully structure code
         */
        public static byte BitsNeeded(int n) {
            ret = 1;
            if (n-- != 0) ** GOTO lbl5
            return 0;
lbl-1000:
            // 1 sources

            {
                ret = (byte)(ret + 1);
lbl5:
                // 2 sources

                ** while ((n >>= 1) != 0)
            }
lbl6:
            // 1 sources

            return ret;
        }

        public static void WriteWord(OutputStream output, short w) throws IOException {
            output.write(w & 0xFF);
            output.write(w >> 8 & 0xFF);
        }

        static void WriteString(OutputStream output, String string) throws IOException {
            int loop = 0;
            while (loop < string.length()) {
                output.write((byte)string.charAt(loop));
                ++loop;
            }
        }
    }
}

