/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class GroupedWriter {
    private int depth = 0;
    private PrintWriter writer;
    private int line_number = 1;
    private boolean begin_line = true;

    public GroupedWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public GroupedWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public void close() {
        this.writer.close();
    }

    public void print(String s) {
        this.doPrint(s);
        this.indent();
    }

    public void println(String s) {
        this.doPrint(s);
        this.doPrint("\n");
    }

    public void println() {
        this.doPrint("\n");
    }

    public void beginGroup() {
        ++this.depth;
        this.indent();
        this.writer.print("{");
    }

    public void startGroup() {
        this.beginGroup();
    }

    public void endGroup() {
        --this.depth;
        this.indent();
        this.writer.print("}");
    }

    public void printGroup(String s) {
        this.beginGroup();
        this.print(s);
        this.endGroup();
    }

    public void printlnGroup(String s) {
        this.beginGroup();
        this.print(s);
        this.endGroup();
        this.println();
    }

    private void doPrint(String s) {
        int newline = s.indexOf(10);
        while (newline >= 0) {
            if (newline > 0) {
                this.indent();
                this.writer.println(this.protect(s.substring(0, newline)));
            } else {
                this.writer.println();
            }
            ++this.line_number;
            this.begin_line = true;
            s = s.substring(newline + 1);
            newline = s.indexOf(10);
        }
        if (s.length() > 0) {
            this.indent();
            this.writer.print(this.protect(s));
        }
    }

    private void indent() {
        if (this.begin_line) {
            int i = 0;
            while (i < this.depth) {
                this.writer.print("\t");
                ++i;
            }
            this.begin_line = false;
        }
    }

    private String protect(String s) {
        int cur_pos = 0;
        while ((cur_pos = this.findFirstIndex(s, cur_pos, "{}\\")) >= 0) {
            s = String.valueOf(s.substring(0, cur_pos)) + "\\" + s.substring(cur_pos);
            cur_pos += 2;
        }
        return s;
    }

    private int findFirstIndex(String s, int pos, String t) {
        int ret = -1;
        int i = 0;
        while (i < t.length()) {
            int next = s.indexOf(t.charAt(i), pos);
            if (next >= 0 && (ret == -1 || next < ret)) {
                ret = next;
            }
            ++i;
        }
        return ret;
    }
}

