/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.util;

import edu.csbsju.socs.util.Strings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HelpFrame
extends JFrame
implements HyperlinkListener {
    protected FileMenu menu_file = new FileMenu();
    protected GoMenu menu_go = new GoMenu();
    protected JEditorPane editor = new JEditorPane();
    protected JScrollPane scroll_pane;
    protected History history = new History();
    protected String base_prefix = null;
    protected ArrayList contents_items = new ArrayList();
    static /* synthetic */ Class class$0;

    public HelpFrame() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.menu_file);
        menubar.add(this.menu_go);
        this.setJMenuBar(menubar);
        this.editor.setEditable(false);
        this.editor.setContentType("text/html");
        this.editor.addHyperlinkListener(this);
        this.editor.setPreferredSize(new Dimension(200, 200));
        this.scroll_pane = new JScrollPane(this.editor);
        this.scroll_pane.setVerticalScrollBarPolicy(22);
        this.scroll_pane.setMinimumSize(new Dimension(10, 10));
        this.getContentPane().add(this.scroll_pane);
        this.renewStrings();
    }

    public void setLocation(URL url) throws NotFoundException {
        this.history.init(url);
    }

    public void renewStrings() {
        this.setTitle(Strings.get("helpDefaultTitle"));
        this.menu_file.renewStrings();
        this.menu_go.renewStrings();
        this.pack();
    }

    public URL getURL(String loc) throws NotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.csbsju.socs.util.HelpFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getClassLoader().getResource(loc);
    }

    public void clearContentsItems() {
        Iterator it = ((AbstractList)this.contents_items).iterator();
        while (it.hasNext()) {
            ContentMenuItem item = (ContentMenuItem)it.next();
            this.menu_go.remove(item);
        }
        this.contents_items.clear();
    }

    public void addContentsItem(String title, URL url) {
        ContentMenuItem to_add = new ContentMenuItem(title, url);
        this.contents_items.add(to_add);
        this.menu_go.add(to_add);
    }

    protected void showError(String message) {
        this.editor.setText("<h1>" + Strings.get("helpErrorTitle") + "</h1>\n" + "<p>" + message + "</p>\n");
    }

    public URL getCurrent() {
        return this.history.getCurrent();
    }

    public void load(URL url) throws NotFoundException {
        if (url == null) {
            throw new NotFoundException(String.valueOf(Strings.get("helpUrlMissingError")) + ": null");
        }
        this.history.addURL(url);
    }

    protected boolean loadURL(URL url) throws NotFoundException {
        try {
            try {
                HTMLDocument doc = (HTMLDocument)this.editor.getDocument();
                doc.setBase(url);
                this.load(url.openStream());
            }
            catch (IOException e) {
                throw new NotFoundException(String.valueOf(Strings.get("helpUrlMissingError")) + ": " + url + " (" + url.getProtocol() + "): " + e.getMessage());
            }
            return true;
        }
        catch (Throwable e) {
            this.showError(e.getMessage());
            return false;
        }
    }

    protected void load(InputStream stream) {
        StringBuffer file_contents = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader fin = new BufferedReader(reader);
        try {
            String line;
            while ((line = fin.readLine()) != null) {
                file_contents.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.editor.getEditorKit().createDefaultDocument();
        this.editor.setText(file_contents.toString());
        this.editor.setCaretPosition(0);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    URL url = e.getURL();
                    if (url == null) {
                        url = new URL(this.history.getCurrent(), e.getDescription());
                    }
                    this.load(url);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static class NotFoundException
    extends Exception {
        public NotFoundException(String msg) {
            super(msg);
        }
    }

    protected class ContentMenuItem
    extends JMenuItem
    implements ActionListener {
        URL url;

        public ContentMenuItem(String title, URL url) {
            super(title);
            this.url = url;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HelpFrame.this.load(this.url);
            }
            catch (NotFoundException ex) {
                JOptionPane.showMessageDialog(HelpFrame.this, ex.getMessage());
            }
        }
    }

    protected class History {
        LinkedList urls = new LinkedList();
        protected int pos = -1;

        protected History() {
        }

        public void init(URL first) throws NotFoundException {
            HelpFrame.this.loadURL(first);
            this.pos = 0;
            this.urls.clear();
            this.urls.add(first);
        }

        public URL getCurrent() {
            if (this.pos < 0 || this.pos >= this.urls.size()) {
                return null;
            }
            return (URL)this.urls.get(this.pos);
        }

        public void back() {
            if (this.pos - 1 >= 0) {
                --this.pos;
                try {
                    HelpFrame.this.loadURL((URL)this.urls.get(this.pos));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }

        public void forward() {
            if (this.pos + 1 < this.urls.size()) {
                ++this.pos;
                try {
                    HelpFrame.this.loadURL((URL)this.urls.get(this.pos));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }

        public void addURL(URL url) throws NotFoundException {
            URL current = this.getCurrent();
            if (current != null && url.equals(current)) {
                return;
            }
            if (HelpFrame.this.loadURL(url)) {
                while (this.urls.size() > this.pos + 1) {
                    this.urls.remove(this.pos + 1);
                }
                this.urls.add(url);
                this.pos = this.urls.size() - 1;
            }
        }
    }

    private class FileMenu
    extends JMenu
    implements ActionListener {
        JMenuItem close = new JMenuItem();

        FileMenu() {
            this.add(this.close);
            this.close.addActionListener(this);
        }

        public void renewStrings() {
            this.setText(Strings.get("fileMenu"));
            this.close.setText(Strings.get("closeMenuItem"));
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.close) {
                HelpFrame.this.hide();
            }
        }
    }

    private class GoMenu
    extends JMenu
    implements ActionListener {
        JMenuItem back = new JMenuItem();
        JMenuItem forward = new JMenuItem();

        GoMenu() {
            this.add(this.back);
            this.back.addActionListener(this);
            this.add(this.forward);
            this.forward.addActionListener(this);
            this.addSeparator();
            this.back.setAccelerator(KeyStroke.getKeyStroke(66, 8));
            this.forward.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        }

        public void renewStrings() {
            this.setText(Strings.get("goMenu"));
            this.back.setText(Strings.get("backMenuItem"));
            this.forward.setText(Strings.get("forwardMenuItem"));
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.back) {
                HelpFrame.this.history.back();
            }
            if (src == this.forward) {
                HelpFrame.this.history.forward();
            }
        }
    }
}

