/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.util;

import edu.csbsju.socs.util.Strings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class LocaleManager {
    private static final String SETTINGS_NAME = "settings";
    private static final String LOCALE_NAME = "str";
    private static ArrayList listeners = new ArrayList();
    private String dir_name;
    private ResourceBundle settings = null;
    private ResourceBundle locale = null;
    private ResourceBundle dflt_locale = null;

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale loc) {
        Locale.setDefault(loc);
        LocaleManager.fireLocaleChanged();
    }

    public static void addListener(Listener l) {
        listeners.add(l);
    }

    public static void removeListener(Listener l) {
        listeners.remove(l);
    }

    private static void fireLocaleChanged() {
        Iterator it = ((AbstractList)listeners).iterator();
        while (it.hasNext()) {
            ((Listener)it.next()).localeChanged();
        }
    }

    public LocaleManager(String dir_name) {
        this.dir_name = dir_name;
        this.loadDefault();
    }

    private void loadDefault() {
        if (this.settings == null) {
            try {
                this.settings = ResourceBundle.getBundle(String.valueOf(this.dir_name) + "/" + SETTINGS_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            this.loadLocale(Locale.getDefault());
            if (this.locale != null) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.loadLocale(Locale.US);
            if (this.locale != null) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Locale[] choices = this.getLocaleOptions();
        if (choices != null && choices.length > 0) {
            LocaleManager.setLocale(choices[0]);
        }
        throw new RuntimeException("No locale bundles are available");
    }

    private void loadLocale(Locale loc) {
        this.locale = ResourceBundle.getBundle(String.valueOf(this.dir_name) + "/" + LOCALE_NAME, loc);
        Locale.setDefault(loc);
        if (this.dflt_locale == null) {
            this.dflt_locale = this.locale;
        }
    }

    public String get(String key) {
        try {
            return this.locale.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return this.dflt_locale.getString(key);
            }
            catch (MissingResourceException missingResourceException2) {
                return key;
            }
        }
    }

    public Locale[] getLocaleOptions() {
        String locs = null;
        try {
            if (this.settings != null) {
                locs = this.settings.getString("locales");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (locs == null) {
            return new Locale[0];
        }
        ArrayList<Locale> retl = new ArrayList<Locale>();
        StringTokenizer toks = new StringTokenizer(locs);
        while (toks.hasMoreTokens()) {
            String f = toks.nextToken();
            String language = f.substring(0, 2);
            String country = f.substring(3, 5);
            Locale loc = new Locale(language, country);
            retl.add(loc);
        }
        Locale[] ret = new Locale[retl.size()];
        int i = 0;
        while (i < retl.size()) {
            ret[i] = (Locale)retl.get(i);
            ++i;
        }
        return ret;
    }

    public JMenuItem createLocaleMenuItem() {
        Locale[] locales = this.getLocaleOptions();
        if (locales == null || locales.length == 0) {
            return null;
        }
        return new LocaleMenu(locales);
    }

    public static interface Listener {
        public void localeChanged();
    }

    private static class LocaleItem
    extends JRadioButtonMenuItem
    implements ActionListener {
        private Locale locale;

        LocaleItem(Locale locale, ButtonGroup bgroup) {
            this.locale = locale;
            bgroup.add(this);
            this.addActionListener(this);
            this.setSelected(locale.equals(LocaleManager.getLocale()));
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.isSelected()) {
                LocaleManager.setLocale(this.locale);
            }
        }
    }

    private static class LocaleMenu
    extends JMenu
    implements Listener {
        LocaleItem[] items;

        LocaleMenu(Locale[] locales) {
            ButtonGroup bgroup = new ButtonGroup();
            this.items = new LocaleItem[locales.length];
            int i = 0;
            while (i < locales.length) {
                this.items[i] = new LocaleItem(locales[i], bgroup);
                this.add(this.items[i]);
                ++i;
            }
            LocaleManager.addListener(this);
            this.localeChanged();
        }

        public void localeChanged() {
            this.setText(Strings.get("localeMenuItem"));
            Locale current = LocaleManager.getLocale();
            int i = 0;
            while (i < this.items.length) {
                LocaleItem it = this.items[i];
                it.setText(it.locale.getDisplayName(current));
                it.setSelected(it.locale.equals(current));
                ++i;
            }
        }
    }

    private class MyListener
    implements Listener {
        MyListener() {
        }

        public void localeChanged() {
            LocaleManager.this.loadDefault();
        }
    }
}

