/*
 * Decompiled with CFR 0.152.
 */
package edu.csbsju.socs.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.RepaintManager;

public class PrintUtilities {
    private static final int TAB_WIDTH = 8;
    private static final Font TEXT_FONT = new Font("Monospaced", 0, 12);

    public static void printText(String text) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new TextPrinter(text));
        if (job.printDialog()) {
            job.print();
        }
    }

    public static void printComponent(Component c) throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new ComponentPrinter(c));
        if (job.printDialog()) {
            job.print();
        }
    }

    private static class ComponentPrinter
    implements Printable {
        private Component componentToBePrinted;

        public ComponentPrinter(Component componentToBePrinted) {
            this.componentToBePrinted = componentToBePrinted;
        }

        public int print(Graphics g, PageFormat format, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(format.getImageableX(), format.getImageableY());
            Dimension dims = this.componentToBePrinted.getSize();
            double scale = Math.min(1.0, Math.min(format.getImageableWidth() / 1.05 / dims.getWidth(), format.getImageableHeight() / 1.05 / dims.getHeight()));
            g2d.scale(scale, scale);
            this.disableDoubleBuffering(this.componentToBePrinted);
            this.componentToBePrinted.paint(g2d);
            this.enableDoubleBuffering(this.componentToBePrinted);
            return 0;
        }

        private void disableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(false);
        }

        private void enableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(true);
        }
    }

    private static class TextPrinter
    implements Printable {
        private ArrayList lines;
        private int lines_per_page;
        private int num_pages;
        private boolean computed = false;

        public TextPrinter(String text) {
            StringTokenizer toks = new StringTokenizer(text, "\n", true);
            String empty = "";
            String last = null;
            this.lines = new ArrayList(toks.countTokens());
            while (toks.hasMoreTokens()) {
                String s = toks.nextToken();
                if (s.equals("\n")) {
                    if (last != null && last.equals("\n")) {
                        this.lines.add(empty);
                    }
                } else {
                    this.lines.add(s);
                }
                last = s;
            }
            int pos = this.lines.size() - 1;
            while (pos >= 0) {
                last = (String)this.lines.get(pos);
                if (!last.trim().equals("")) break;
                this.lines.remove(pos);
                --pos;
            }
        }

        public int print(Graphics g, PageFormat format, int pageIndex) {
            if (!this.computed) {
                this.compute(g, format);
            }
            if (pageIndex >= this.num_pages) {
                return 1;
            }
            g.setColor(Color.black);
            g.setFont(TEXT_FONT);
            FontMetrics fm = g.getFontMetrics();
            int line_height = fm.getHeight();
            int x = (int)Math.ceil(format.getImageableX());
            int y = (int)Math.ceil(format.getImageableY()) + fm.getAscent();
            int base = this.lines_per_page * pageIndex;
            int row = 0;
            while (row < this.lines_per_page && base + row < this.lines.size()) {
                String line = (String)this.lines.get(base + row);
                if (!(line = this.expandTabs(line)).trim().equals("")) {
                    g.drawString(line, x, y);
                }
                y += line_height;
                ++row;
            }
            return 0;
        }

        private void compute(Graphics g, PageFormat format) {
            this.computed = true;
            g.setFont(TEXT_FONT);
            FontMetrics fm = g.getFontMetrics();
            int line_height = fm.getHeight();
            int leading = fm.getLeading();
            int page_height = (int)format.getImageableHeight();
            this.lines_per_page = (page_height - leading) / line_height;
            this.num_pages = (this.lines.size() + this.lines_per_page - 1) / this.lines_per_page;
        }

        private String expandTabs(String base) {
            int next;
            String ret = "";
            int pos = 0;
            while ((next = base.indexOf(9, pos)) >= 0) {
                String tab = " ";
                int spaces = (next + 8 - 1 - pos) % 8;
                int i = 0;
                while (i < spaces) {
                    tab = String.valueOf(tab) + " ";
                    ++i;
                }
                ret = String.valueOf(ret) + tab + base.substring(pos, next);
                pos = next + 1;
            }
            ret = String.valueOf(ret) + base.substring(pos);
            return ret;
        }
    }
}

