/*
 * Decompiled with CFR 0.152.
 */
package socs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import socs.Button;
import socs.ExitOnDone;
import socs.Label;

public class ButtonWindow {
    private JFrame frame;
    private Object lock = new Object();
    private Button clicked = null;

    public ButtonWindow(String string) {
        this.frame = new JFrame(string);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
    }

    public void add(Label label) {
        JPanel jPanel = new JPanel();
        jPanel.add(label.getComponent());
        this.frame.getContentPane().add(jPanel);
    }

    public void add(Button button) {
        JButton jButton = button.getComponent();
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        this.frame.getContentPane().add(jPanel);
        jButton.addActionListener(new MyActionListener(button));
    }

    public void dispose() {
        this.frame.dispose();
        ExitOnDone.instance.removeFrame(this.frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Button getNextClick() {
        Button button;
        Object object = this.lock;
        synchronized (object) {
            while (this.clicked == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            button = this.clicked;
            this.clicked = null;
        }
        return button;
    }

    public double requestDouble(String string) {
        JTextField jTextField = new JTextField(8);
        JButton jButton = new JButton("OK");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jTextField);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, null, new Object[]{jPanel});
        JDialog jDialog = jOptionPane.createDialog(this.frame, "Number Request");
        class DoubleListener
        implements ActionListener {
            private final /* synthetic */ JTextField val$field;
            private final /* synthetic */ JDialog val$dlog;

            DoubleListener(JTextField jTextField, JDialog jDialog) {
                this.val$field = jTextField;
                this.val$dlog = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Double.parseDouble(this.val$field.getText());
                    this.val$dlog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.val$dlog, "You must type a valid number.");
                }
            }
        }
        jTextField.addActionListener(new DoubleListener(jTextField, jDialog));
        jButton.addActionListener(new DoubleListener(jTextField, jDialog));
        jTextField.grabFocus();
        jDialog.show();
        String string2 = jTextField.getText();
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public void show() {
        this.frame.pack();
        this.frame.show();
        ExitOnDone.instance.addFrame(this.frame);
    }

    private class MyActionListener
    implements ActionListener {
        private Button button;

        private MyActionListener(Button button) {
            this.button = button;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = ButtonWindow.this.lock;
            synchronized (object) {
                ButtonWindow.this.clicked = this.button;
                ButtonWindow.this.lock.notifyAll();
            }
        }
    }
}

