/*
 * Decompiled with CFR 0.152.
 */
package socs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.EtchedBorder;
import socs.ExitOnDone;

public class IOWindow {
    private static final boolean DR_JAVA = false;
    private static final String WORD_SEPARATORS = " \n\r\t";
    private MyFrame frame = null;
    private InputBuffer buffer = new InputBuffer();

    public IOWindow() {
        this.frame = new MyFrame("I/O Console");
        this.frame.pack();
        this.frame.show();
        ExitOnDone.instance.addFrame(this.frame);
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    public void setSize(int n, int n2) {
        this.frame.io.setSize(n, n2);
        this.frame.pack();
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void clear() {
        this.frame.io.clear();
    }

    public void print(Object object) {
        this.frame.io.print(object.toString());
    }

    public void print(int n) {
        this.print(Integer.toString(n));
    }

    public void print(double d) {
        this.print(Double.toString(d));
    }

    public void print(boolean bl) {
        this.print("" + bl);
    }

    public void print(char c) {
        this.print("" + c);
    }

    public void println() {
        this.frame.io.print("\n");
    }

    public void println(Object object) {
        this.frame.io.print(object.toString() + '\n');
    }

    public void println(int n) {
        this.println(Integer.toString(n));
    }

    public void println(double d) {
        this.println(Double.toString(d));
    }

    public void println(boolean bl) {
        this.println("" + bl);
    }

    public void println(char c) {
        this.println("" + c);
    }

    public String readLine() {
        return this.buffer.getLine();
    }

    public char readChar() {
        return this.buffer.getChar();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public boolean readBoolean() {
        return this.buffer.getBoolean();
    }

    public String readString() {
        return this.buffer.getWord();
    }

    private class InputBuffer {
        private String buf = null;

        private InputBuffer() {
        }

        private void getBuffer() {
            if (this.buf == null) {
                this.buf = ((IOWindow)IOWindow.this).frame.io.readLine();
            }
        }

        private void toNextWord() {
            int n;
            int[] nArray = new int[IOWindow.WORD_SEPARATORS.length()];
            if (this.buf != null) {
                for (n = 0; n < this.buf.length() && IOWindow.WORD_SEPARATORS.indexOf(this.buf.charAt(n)) >= 0; ++n) {
                }
                this.buf = this.buf.substring(n);
            }
            while (this.buf == null || this.buf.equals("")) {
                this.buf = null;
                this.getBuffer();
                for (n = 0; n < this.buf.length() && IOWindow.WORD_SEPARATORS.indexOf(this.buf.charAt(n)) >= 0; ++n) {
                }
                this.buf = this.buf.substring(n);
            }
        }

        public String getLine() {
            if (this.buf != null && this.buf.equals("")) {
                this.buf = null;
            }
            this.getBuffer();
            String string = this.buf;
            this.buf = null;
            return string;
        }

        public char getChar() {
            this.getBuffer();
            if (this.buf.equals("")) {
                this.buf = null;
                return '\n';
            }
            char c = this.buf.charAt(0);
            this.buf = this.buf.substring(1);
            return c;
        }

        public String getWord() {
            int n;
            this.toNextWord();
            for (n = 0; n < this.buf.length() && IOWindow.WORD_SEPARATORS.indexOf(this.buf.charAt(n)) < 0; ++n) {
            }
            String string = this.buf.substring(0, n);
            this.buf = this.buf.substring(n);
            return string;
        }

        public boolean getBoolean() {
            return this.getWord().equalsIgnoreCase("true");
        }

        public int getInt() {
            this.toNextWord();
            int n = 0;
            if (n < this.buf.length() + 1 && this.buf.charAt(n) == '-' && Character.isDigit(this.buf.charAt(n + 1))) {
                ++n;
            }
            while (n < this.buf.length() && Character.isDigit(this.buf.charAt(n))) {
                ++n;
            }
            if (n == 0) {
                this.buf = this.buf.substring(1);
                return Integer.MIN_VALUE;
            }
            int n2 = Integer.parseInt(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return n2;
        }

        public double getDouble() {
            this.toNextWord();
            int n = -1;
            int n2 = 0;
            for (int i = 0; i < this.buf.length() && n2 >= 0; ++i) {
                char c = this.buf.charAt(i);
                int n3 = n2;
                n2 = -1;
                switch (n3) {
                    case 0: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '+' || c == '-') {
                            n2 = 1;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c != '.') break;
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        if (Character.isDigit(c)) {
                            n2 = 2;
                            break;
                        }
                        if (c == '.') {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 3: {
                        if (!Character.isDigit(c)) break;
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        if (Character.isDigit(c)) {
                            n2 = 4;
                            break;
                        }
                        if (c != 'e' && c != 'E') break;
                        n2 = 5;
                        break;
                    }
                    case 5: {
                        if (Character.isDigit(c)) {
                            n2 = 7;
                            break;
                        }
                        if (c != '-' && c != '+') break;
                        n2 = 6;
                        break;
                    }
                    case 6: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                        break;
                    }
                    case 7: {
                        if (!Character.isDigit(c)) break;
                        n2 = 7;
                    }
                }
                if (n2 != 2 && n2 != 4 && n2 != 7) continue;
                n = i + 1;
            }
            if (n < 0) {
                this.buf = this.buf.substring(1);
                return Double.NaN;
            }
            double d = Double.parseDouble(this.buf.substring(0, n));
            this.buf = this.buf.substring(n);
            return d;
        }
    }

    private class MyFrame
    extends JFrame
    implements WindowListener,
    ActionListener {
        protected ClipOwner owner = new ClipOwner();
        public JMenuItem clear_item = new JMenuItem("Clear");
        public JMenuItem copy_item = new JMenuItem("Copy All");
        public JMenuItem close_item = new JMenuItem("Quit");
        public IOArea io = new IOArea();

        public MyFrame(String string) {
            super(string);
            this.addWindowListener(this);
            this.setBackground(Color.white);
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            this.clear_item.addActionListener(this);
            jMenu.add(this.clear_item);
            this.copy_item.addActionListener(this);
            jMenu.add(this.copy_item);
            this.close_item.addActionListener(this);
            jMenu.add(this.close_item);
            this.getContentPane().add(this.io);
            this.pack();
            this.io.grabFocus();
        }

        public void dispose() {
            super.dispose();
            ExitOnDone.instance.removeFrame(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.clear_item) {
                this.io.clear();
            } else if (actionEvent.getSource() == this.copy_item) {
                Clipboard clipboard = IOWindow.this.frame.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(this.io.getText());
                clipboard.setContents(stringSelection, this.owner);
            } else if (actionEvent.getSource() == this.close_item) {
                IOWindow.this.frame.dispose();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            ExitOnDone.instance.removeFrame(IOWindow.this.frame);
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        protected class ClipOwner
        implements ClipboardOwner {
            protected ClipOwner() {
            }

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        }
    }

    private static class IOArea
    extends JPanel
    implements KeyListener,
    AdjustmentListener {
        protected static final char HUMAN = '\u0001';
        protected static final char COMPUTER = '\u0002';
        protected static final String PROMPT = "? \u0001";
        protected static final int NUM_ROWS = 10;
        protected static final int NUM_COLS = 50;
        protected Font computer_font = new Font("Monospaced", 0, 12);
        protected Font user_font = new Font("Monospaced", 1, 12);
        protected Color computer_color = Color.black;
        protected Color user_color = Color.blue;
        protected Vector text = new Vector();
        protected String buffer = "";
        protected IOCanvas canvas;
        protected IOScrollBar scrollbar;

        public IOArea() {
            super(new BorderLayout());
            this.setBorder(new EtchedBorder());
            this.canvas = new IOCanvas();
            this.add((Component)this.canvas, "Center");
            this.scrollbar = new IOScrollBar();
            this.add((Component)this.scrollbar, "East");
            this.text.add("");
            this.canvas.addKeyListener(this);
            this.scrollbar.addAdjustmentListener(this);
        }

        public void clear() {
            this.text = new Vector();
            this.buffer = "";
            this.scrollbar.update();
            this.canvas.repaint();
        }

        public void setSize(int n, int n2) {
            this.canvas.setSize(n, n2);
        }

        public void print(String string) {
            this.moveToBottom();
            this.addText('\u0002', string);
        }

        public synchronized String readLine() {
            this.moveToBottom();
            this.canvas.grabFocus();
            while (this.available() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            int n = this.buffer.indexOf(10);
            String string = this.buffer.substring(0, n);
            this.buffer = this.buffer.substring(n + 1);
            this.addText('\u0001', string + '\n');
            return string;
        }

        public int available() {
            return this.buffer.indexOf(10) < 0 ? 0 : this.buffer.length();
        }

        public void grabFocus() {
            this.canvas.grabFocus();
        }

        protected void moveToBottom() {
            this.scrollbar.setValue(this.scrollbar.getMaximum());
        }

        protected String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.text.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0001\u0002");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.buffer);
            return stringBuffer.toString();
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.canvas.top_row = adjustmentEvent.getValue();
            this.canvas.repaint();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public synchronized void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\b' || c == '\u007f' || keyEvent.paramString().indexOf("Backspace") >= 0) {
                if (this.buffer.length() > 0) {
                    this.buffer = this.buffer.substring(0, this.buffer.length() - 1);
                    this.scrollbar.update();
                    this.moveToBottom();
                    this.canvas.repaint();
                }
                return;
            }
            this.buffer = this.buffer + c;
            this.scrollbar.update();
            this.moveToBottom();
            this.canvas.repaint();
            if (c == '\n') {
                this.scrollbar.update();
                this.notifyAll();
            }
        }

        protected void addText(char c, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("\n")) {
                    this.text.add("");
                    continue;
                }
                this.ensureUser(c);
                String string3 = (String)this.text.lastElement();
                this.text.setElementAt(string3 + string2, this.text.size() - 1);
            }
            this.scrollbar.update();
            this.canvas.repaint();
        }

        protected void ensureUser(char c) {
            char c2;
            String string;
            if (this.text.size() == 0) {
                string = "";
                this.text.add(string);
            } else {
                string = (String)this.text.lastElement();
            }
            int n = string.lastIndexOf(2);
            int n2 = string.lastIndexOf(1);
            char c3 = c2 = n2 > n ? (char)'\u0001' : '\u0002';
            if (c2 != c) {
                this.text.setElementAt(string + c, this.text.size() - 1);
            }
        }

        protected static int countOccurrences(String string, char c) {
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(c, n2)) >= 0) {
                ++n;
                ++n2;
            }
            return n;
        }

        protected class IOScrollBar
        extends JScrollBar {
            public IOScrollBar() {
                this.setMinimum(0);
                this.setUnitIncrement(1);
                this.setBlockIncrement(10);
                this.setVisibleAmount(10);
                this.update();
            }

            public void update() {
                boolean bl = this.getValue() == this.getMaximum();
                int n = this.getValue();
                int n2 = IOArea.this.canvas.getRows();
                int n3 = IOArea.this.text.size();
                if ((n3 += IOArea.countOccurrences(IOArea.this.buffer, '\n')) < n2) {
                    n3 = n2;
                }
                this.setValue(0);
                this.setBlockIncrement(n2);
                this.setVisibleAmount(n2);
                this.setMaximum(n3);
                if (bl || n > this.getMaximum()) {
                    this.setValue(this.getMaximum());
                } else {
                    this.setValue(n);
                }
            }
        }

        protected class IOCanvas
        extends JPanel
        implements MouseListener,
        FocusListener,
        ComponentListener {
            public int top_row = 0;

            public IOCanvas() {
                this.setBackground(Color.white);
                this.addMouseListener(this);
                this.addFocusListener(this);
                this.addComponentListener(this);
                this.setSize(50, 10);
            }

            public void setSize(int n, int n2) {
                Rectangle2D rectangle2D = IOArea.this.computer_font.getStringBounds("x", new FontRenderContext(null, false, false));
                this.setPreferredSize(new Dimension((int)((double)n * rectangle2D.getWidth()), (int)((double)n2 * rectangle2D.getHeight())));
            }

            public int getRows() {
                Rectangle2D rectangle2D = IOArea.this.computer_font.getStringBounds("x", new FontRenderContext(null, false, false));
                Dimension dimension = this.getSize();
                return (int)((double)dimension.height / rectangle2D.getHeight());
            }

            public void paintComponent(Graphics graphics) {
                String string;
                super.paintComponent(graphics);
                graphics.setFont(IOArea.this.computer_font);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = 0;
                int n2 = fontMetrics.getLeading() + fontMetrics.getAscent();
                for (int i = this.top_row; i < IOArea.this.text.size(); ++i) {
                    string = (String)IOArea.this.text.get(i);
                    n = this.paintLine(graphics, string, 0, n2);
                    n2 += fontMetrics.getHeight();
                }
                n2 -= fontMetrics.getHeight();
                StringTokenizer stringTokenizer = new StringTokenizer(IOArea.this.buffer, "\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.equals("\n")) {
                        n2 += fontMetrics.getHeight();
                        n = 0;
                        continue;
                    }
                    n = this.paintLine(graphics, "\u0001" + string, n, n2);
                }
                if (this.hasFocus()) {
                    graphics.drawLine(n, n2, n, n2 - fontMetrics.getAscent());
                }
            }

            protected int paintLine(Graphics graphics, String string, int n, int n2) {
                int n3 = 2;
                graphics.setFont(IOArea.this.computer_font);
                graphics.setColor(IOArea.this.computer_color);
                int n4 = 0;
                while (n4 < string.length()) {
                    graphics.setFont(n3 == 2 ? IOArea.this.computer_font : IOArea.this.user_font);
                    graphics.setColor(n3 == 2 ? IOArea.this.computer_color : IOArea.this.user_color);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n5 = string.length();
                    int n6 = string.indexOf(2, n4);
                    if (n6 >= 0 && n6 < n5) {
                        n5 = n6;
                        n3 = 2;
                    }
                    if ((n6 = string.indexOf(1, n4)) >= 0 && n6 < n5) {
                        n5 = n6;
                        n3 = 1;
                    }
                    String string2 = string.substring(n4, n5);
                    graphics.drawString(string2, n, n2);
                    n += fontMetrics.stringWidth(string2);
                    n4 = n5 + 1;
                }
                return n;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.grabFocus();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                this.repaint();
            }

            public void focusGained(FocusEvent focusEvent) {
                this.repaint();
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                IOArea.this.scrollbar.update();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        }
    }
}

