/*
 * Decompiled with CFR 0.152.
 */
package socs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import socs.RobotWindow;

public class Robot
implements RobotWindow.DrawingItem {
    static javax.swing.Icon icon = new Icon();
    private static int FRAME_SIZE = 40;
    private static double NORMAL_TURN_VEL = 0.1;
    private static double NORMAL_MOVE_ACC = 0.2;
    private static double NORMAL_MOVE_VEL = 4.0;
    private static double FAST_TURN_VEL = 0.2;
    private static double FAST_MOVE_ACC = 0.4;
    private static double FAST_MOVE_VEL = 8.0;
    private RobotWindow win;
    private double x;
    private double y;
    private double direction;
    private double cos;
    private double sin;
    private boolean is_on = true;
    private boolean has_tail;
    private int tail_x;
    private int tail_y;

    public Robot(RobotWindow robotWindow, double d, double d2) {
        this.win = robotWindow;
        this.x = d;
        this.y = d2;
        this.direction = 0.0;
        this.cos = 1.0;
        this.sin = 0.0;
        this.has_tail = false;
        robotWindow.addDrawingItem(this);
        robotWindow.repaint();
    }

    public void turn(double d) {
        if (!this.is_on) {
            return;
        }
        double d2 = d * Math.PI / 180.0;
        if (d2 == 0.0) {
            return;
        }
        double d3 = this.direction;
        double d4 = 0.0;
        FrameRate frameRate = new FrameRate(FRAME_SIZE);
        while (d4 != d2) {
            double d5;
            switch (this.win.getSpeed()) {
                case 2: {
                    d5 = Double.MAX_VALUE;
                    break;
                }
                case 1: {
                    d5 = FAST_TURN_VEL;
                    break;
                }
                default: {
                    d5 = NORMAL_TURN_VEL;
                }
            }
            d4 = d5 == Double.MAX_VALUE ? d2 : (d2 > 0.0 ? Math.min(d4 + d5, d2) : Math.max(d4 - d5, d2));
            this.direction = d3 + d4;
            if (this.direction < -Math.PI) {
                this.direction += Math.PI * 2;
            }
            if (this.direction > Math.PI) {
                this.direction -= Math.PI * 2;
            }
            this.cos = Math.cos(this.direction);
            this.sin = Math.sin(this.direction);
            this.win.repaint();
            frameRate.next();
        }
    }

    public void move(double d) {
        if (!this.is_on) {
            return;
        }
        this.tail_x = (int)Math.round(this.x);
        this.tail_y = (int)Math.round(this.y);
        this.has_tail = true;
        double d2 = this.x;
        double d3 = this.y;
        double d4 = 0.0;
        double d5 = 0.0;
        FrameRate frameRate = new FrameRate(FRAME_SIZE);
        block4: while (d4 != d) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            switch (this.win.getSpeed()) {
                case 2: {
                    this.x = d2 + d * this.cos;
                    this.y = d3 - d * this.sin;
                    break block4;
                }
                case 1: {
                    d12 = FAST_MOVE_VEL;
                    d11 = FAST_MOVE_ACC;
                    break;
                }
                default: {
                    d12 = NORMAL_MOVE_VEL;
                    d11 = NORMAL_MOVE_ACC;
                }
            }
            if (d5 > d12) {
                d5 = d12;
            }
            if (d4 + (d10 = Math.min(0.5 * (d9 = Math.min(d5 + d11, d12)) * d9 / d11, d - d4) - 0.1) >= d) {
                d4 += d5 - 0.5 * d11;
                d5 -= d11;
            } else if (d5 + d11 < d12) {
                d8 = d5 + 0.5 * d11;
                if (d4 + d8 + d10 <= d) {
                    d4 += d8;
                    d5 += d11;
                } else {
                    d7 = d - d10 - d4;
                    d6 = d5;
                    double d13 = (Math.sqrt(d6 * d6 + 2.0 * d11 * d7) - d6) / d11;
                    d13 = Math.max(0.0, Math.min(1.0, d13));
                    d4 += (d5 + 0.5 * d11 * d13) * d13;
                    d4 += ((d5 += d11 * d13) - 0.5 * d11 * (1.0 - d13)) * (1.0 - d13);
                    d5 -= d11 * (1.0 - d13);
                }
            } else if (d5 < d12) {
                d8 = Math.min(1.0, (d12 - d5) / d11);
                d7 = d5 * (d8 = Math.max(0.0, d8)) + 0.5 * d11 * d8 * d8 + (1.0 - d8) * d12;
                if (d4 + d7 + d10 <= d) {
                    d4 += d7;
                    d5 = d12;
                } else {
                    d5 = d12;
                    d6 = d - d10 - d4;
                    d8 = d6 / d5;
                    d4 += d5 * d8 + d5 * (1.0 - d8) - 0.5 * d11 * (1.0 - d8) * (1.0 - d8);
                    d5 -= d11 * (1.0 - d8);
                }
            } else if (d4 + d5 + d10 <= d) {
                d4 += d5;
            } else {
                d8 = d - d10 - d4;
                d7 = d8 / d5;
                d4 += d5 * d7 + d5 * (1.0 - d7) - 0.5 * d11 * (1.0 - d7) * (1.0 - d7);
                d5 -= d11 * (1.0 - d7);
            }
            if (Double.isNaN(d4)) break;
            d4 = Math.min(d4 + 0.01, d);
            this.x = d2 + d4 * this.cos;
            this.y = d3 - d4 * this.sin;
            this.win.repaint();
            frameRate.next();
        }
        this.win.drawLine(this.tail_x, this.tail_y, (int)Math.round(this.x), (int)Math.round(this.y));
        this.has_tail = false;
    }

    private void wait(int n) {
        if (!this.is_on) {
            return;
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void switchOff() {
        if (!this.is_on) {
            return;
        }
        this.is_on = false;
        this.win.removeDrawingItem(this);
        this.win.repaint();
    }

    public void drawCursor(Graphics graphics) {
        Robot.paint(graphics, this.x, this.y, this.cos, this.sin);
    }

    public void draw(Graphics graphics) {
        if (this.has_tail) {
            graphics.setColor(Color.black);
            graphics.drawLine(this.tail_x, this.tail_y, (int)Math.round(this.x), (int)Math.round(this.y));
        }
    }

    private static void paint(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = (int)(d + 0.5);
        int n2 = (int)(d2 + 0.5);
        int n3 = (int)(d + 5.0 * d3 + 0.5);
        int n4 = (int)(d2 - 5.0 * d4 + 0.5);
        graphics.setColor(Color.blue);
        graphics.fillOval(n - 5, n2 - 5, 11, 11);
        graphics.setColor(Color.white);
        graphics.fillOval(n - 3, n2 - 3, 7, 7);
        graphics.setColor(Color.blue);
        graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
    }

    private static class Icon
    implements javax.swing.Icon {
        private Icon() {
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Robot.paint(graphics, 10.0, 10.0, 0.707, 0.707);
        }
    }

    private static class FrameRate {
        int duration;
        long last_frame;

        public FrameRate(int n) {
            this.duration = n;
            this.last_frame = System.currentTimeMillis();
        }

        public void next() {
            this.last_frame += (long)this.duration;
            long l = this.last_frame - System.currentTimeMillis();
            if (l >= 0L) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

