/*
 * Decompiled with CFR 0.152.
 */
package socs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import socs.ExitOnDone;
import socs.Robot;

public class RobotWindow {
    private static final String TITLE = "Robot Window";
    static final int NORMAL = 0;
    static final int FAST = 1;
    static final int INSTANT = 2;
    private JFrame frame;
    private MyPanel panel;
    private LinkedList drawing_items = new LinkedList();
    private int speed = 0;

    public RobotWindow() {
        this.frame = new JFrame(TITLE);
        this.frame.addWindowListener(new MyWindowListener());
        this.frame.setTitle(TITLE);
        this.frame.setBackground(Color.white);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener(new MyActionListener());
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Speed");
        ButtonGroup buttonGroup = new ButtonGroup();
        SpeedItem speedItem = new SpeedItem(0);
        jMenu2.add(speedItem);
        buttonGroup.add(speedItem);
        speedItem = new SpeedItem(1);
        jMenu2.add(speedItem);
        buttonGroup.add(speedItem);
        speedItem = new SpeedItem(2);
        jMenu2.add(speedItem);
        buttonGroup.add(speedItem);
        jMenuBar.add(jMenu2);
        this.frame.setJMenuBar(jMenuBar);
        this.panel = new MyPanel();
        this.frame.getContentPane().add(this.panel);
    }

    public void show() {
        this.frame.pack();
        this.frame.show();
        ExitOnDone.instance.addFrame(this.frame);
    }

    public void dispose() {
        this.frame.dispose();
        ExitOnDone.instance.removeFrame(this.frame);
    }

    public void notify(String string) {
        JButton jButton = new JButton("OK");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, Robot.icon, new Object[]{jPanel});
        JDialog jDialog = jOptionPane.createDialog(this.frame, "Notification");
        class CloseListener
        implements ActionListener {
            private final /* synthetic */ JDialog val$dlog;

            CloseListener(JDialog jDialog) {
                this.val$dlog = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dlog.dispose();
            }
        }
        jButton.addActionListener(new CloseListener(jDialog));
        jDialog.show();
    }

    public double requestDouble() {
        return this.requestDouble("Please type a number.");
    }

    public double requestDouble(String string) {
        JTextField jTextField = new JTextField(8);
        JButton jButton = new JButton("OK");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jTextField);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, Robot.icon, new Object[]{jPanel});
        JDialog jDialog = jOptionPane.createDialog(this.frame, "Number Request");
        class DoubleListener
        implements ActionListener {
            private final /* synthetic */ JTextField val$field;
            private final /* synthetic */ JDialog val$dlog;

            DoubleListener(JTextField jTextField, JDialog jDialog) {
                this.val$field = jTextField;
                this.val$dlog = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Double.parseDouble(this.val$field.getText());
                    this.val$dlog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.val$dlog, "You must type a valid number.");
                }
            }
        }
        jTextField.addActionListener(new DoubleListener(jTextField, jDialog));
        jButton.addActionListener(new DoubleListener(jTextField, jDialog));
        jTextField.grabFocus();
        jDialog.show();
        String string2 = jTextField.getText();
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public int requestInt() {
        return this.requestInt("Please type an integer.");
    }

    public int requestInt(String string) {
        JTextField jTextField = new JTextField(8);
        JButton jButton = new JButton("OK");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jTextField);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, Robot.icon, new Object[]{jPanel});
        JDialog jDialog = jOptionPane.createDialog(this.frame, "Integer Request");
        class IntegerListener
        implements ActionListener {
            private final /* synthetic */ JTextField val$field;
            private final /* synthetic */ JDialog val$dlog;

            IntegerListener(JTextField jTextField, JDialog jDialog) {
                this.val$field = jTextField;
                this.val$dlog = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer.parseInt(this.val$field.getText());
                    this.val$dlog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.val$dlog, "You must type a valid integer.");
                }
            }
        }
        jTextField.addActionListener(new IntegerListener(jTextField, jDialog));
        jButton.addActionListener(new IntegerListener(jTextField, jDialog));
        jTextField.grabFocus();
        jDialog.show();
        String string2 = jTextField.getText();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void repaint() {
        this.panel.repaint();
    }

    void addDrawingItem(DrawingItem drawingItem) {
        this.drawing_items.add(drawingItem);
    }

    void removeDrawingItem(DrawingItem drawingItem) {
        this.drawing_items.remove(drawingItem);
    }

    void drawLine(int n, int n2, int n3, int n4) {
        Graphics graphics = this.panel.getImage().getGraphics();
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2, n3, n4);
    }

    int getSpeed() {
        return this.speed;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RobotWindow.this.dispose();
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            RobotWindow.this.dispose();
        }
    }

    private class SpeedItem
    extends JRadioButtonMenuItem
    implements ActionListener {
        int value;

        public SpeedItem(int n) {
            this.value = n;
            switch (n) {
                case 0: {
                    this.setText("Normal");
                    break;
                }
                case 1: {
                    this.setText("Fast");
                    break;
                }
                case 2: {
                    this.setText("Instant");
                }
            }
            this.setSelected(RobotWindow.this.speed == n);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RobotWindow.this.speed = this.value;
        }
    }

    private class MyPanel
    extends JPanel {
        private static final int WIDTH = 200;
        private static final int HEIGHT = 200;
        Image image = null;

        MyPanel() {
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(200, 200));
            this.setMinimumSize(new Dimension(200, 200));
        }

        Image getImage() {
            if (this.image == null) {
                this.image = this.createImage(200, 200);
                if (this.image == null) {
                    throw new NullPointerException("could not create image");
                }
                Graphics graphics = this.image.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, 200, 200);
            }
            return this.image;
        }

        public void paintComponent(Graphics graphics) {
            DrawingItem drawingItem;
            super.paintComponent(graphics);
            graphics.setColor(Color.white);
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            }
            Iterator iterator = RobotWindow.this.drawing_items.iterator();
            while (iterator.hasNext()) {
                drawingItem = (DrawingItem)iterator.next();
                drawingItem.draw(graphics);
            }
            iterator = RobotWindow.this.drawing_items.iterator();
            while (iterator.hasNext()) {
                drawingItem = (DrawingItem)iterator.next();
                drawingItem.drawCursor(graphics);
            }
            graphics.setColor(Color.white);
        }
    }

    static interface DrawingItem {
        public void draw(Graphics var1);

        public void drawCursor(Graphics var1);
    }
}

